
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              November 2018                        *
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


* ---------------------------------------
* Datenaufbereitung
* ---------------------------------------
* Nur hauptberuflich ganztags, bis Alter 65
keep if  hauptber == 1
keep if  alter <  66


*****************************************************
* Interaktion mit Kreuztabelle (Kap. 1)
*****************************************************
generate hohebild = bild>12.5          // mind. 13 Jahre Bildung
replace  hohebild = .   if bild==.     // Achtung Fehlerquelle: "." ist +Unendlich

tab arblos hohebild, col chi2 V
bysort ost: tab arblos hohebild, col chi2 V


*****************************************************
* Regression mit Interaktionen
*****************************************************

* Zentrierung der Bildungsvariable
* Achtung: muss auf das Schätz-Sample (miss==0) der Regression berechnet werden
egen miss = rowmiss(eink bild)            //Zahl der MV auf den relevanten Variablen
tab miss                                  //N=1118 ohne MV
summ  bild                    if miss==0  //Bildungs-Mittelwert wird erzeugt [r(mean)]
gen   cbild = bild - r(mean)  if miss==0  //Abziehen des Bildungs-Mittelwerts


* ----------------------------------
* Regression mit Dummy-Interaktion
* ----------------------------------

* ohne Interaktion
regress eink bild i.frau i.ost
margins frau#ost, at(bild=(8 18))
marginsplot,   noci    title("")                                    ///
   plot1opts(lwidth(thick) lcolor(blue)  msymbol(i))                ///
   plot2opts(lwidth(thick) lcolor(green) msymbol(i))                ///
   plot3opts(lwidth(thick) lcolor(red)   msymbol(i))                ///
   plot4opts(lwidth(thick) lcolor(brown) msymbol(i))                ///
   ytitle(Einkommen, size(large))                                   ///  
   ylabel(0(500)3500, labsize(medlarge) angle(horizontal) grid)     ///
   xtitle(Bildungsjahre, size(large) margin(medsmall))              ///  
   xlabel(8(1)18, labsize(medlarge))                                ///
   legend(pos(11) ring(0) row(2) order(1 2 3 4) lab(1 "Mann West")  ///
		     lab(2 "Mann Ost") lab(3 "Frau West") lab(4 "Frau Ost") ///
			 size(medium))  


* mit Interaktion
regress eink bild i.frau i.ost frau#ost
margins frau#ost, at(bild=(8 18))
marginsplot,   noci    title("")                                    ///
   plot1opts(lwidth(thick) lcolor(blue)  msymbol(i))                ///
   plot2opts(lwidth(thick) lcolor(green) msymbol(i))                ///
   plot3opts(lwidth(thick) lcolor(red)   msymbol(i))                ///
   plot4opts(lwidth(thick) lcolor(brown) msymbol(i))                ///
   ytitle(Einkommen, size(large))                                   ///  
   ylabel(0(500)3500, labsize(medlarge) angle(horizontal) grid)     ///
   xtitle(Bildungsjahre, size(large) margin(medsmall))              ///  
   xlabel(8(1)18, labsize(medlarge))                                ///
   legend(pos(11) ring(0) row(2) order(1 2 3 4) lab(1 "Mann West")  ///
		     lab(2 "Mann Ost") lab(3 "Frau West") lab(4 "Frau Ost") ///
			 size(medium))  


* ----------------------------------
* Regression mit Slope-Interaktion
* ----------------------------------

* ohne Interaktion
regress eink c.bild i.frau
margins frau, at(bild=(8 18))
marginsplot,   noci    title("")                                    ///
   plot1opts(lwidth(thick) lcolor(blue)  msymbol(i))                ///
   plot2opts(lwidth(thick) lcolor(red) msymbol(i))                  ///
   ytitle(Einkommen, size(large))                                   ///  
   ylabel(0(500)3000, labsize(medlarge) angle(horizontal) grid)     ///
   xtitle(Bildungsjahre, size(large) margin(medsmall))              ///  
   xlabel(8(1)18, labsize(medlarge))                                ///
   legend(pos(11) ring(0) row(2) order(1 2) lab(1 "Mann")           ///
		     lab(2 "Frau") size(medlarge))  


* mit Interaktion
regress eink c.bild i.frau i.frau#c.bild
margins frau, at(bild=(8 18))
marginsplot,   noci    title("")                                    ///
   plot1opts(lwidth(thick) lcolor(blue)  msymbol(i))                ///
   plot2opts(lwidth(thick) lcolor(red) msymbol(i))                  ///
   ytitle(Einkommen, size(large))                                   ///  
   ylabel(0(500)3000, labsize(medlarge) angle(horizontal) grid)     ///
   xtitle(Bildungsjahre, size(large) margin(medsmall))              ///  
   xlabel(8(1)18, labsize(medlarge))                                ///
   legend(pos(11) ring(0) row(2) order(1 2) lab(1 "Mann")           ///
		     lab(2 "Frau") size(medlarge))  


* ------------------------------------
* Interaktion mit zentrierter Bildung
* ------------------------------------
regress eink c.cbild i.frau i.frau#c.cbild


*--------------------------------------
*  Conditional-Effect I
*--------------------------------------
*  Marginaleffekt von "Bildung" in Abängigkeit von Geschlecht
margins frau, dydx(cbild)

* Auch erhältlich mit "nested effects"
gen   cbild_f = cbild * (frau==1)      //Bildungsvariable für Frauen
gen   cbild_m = cbild * (frau==0)      //Bildungsvariable für Männer
tab cbild_f frau                       //so soll es sein
regress eink cbild_m cbild_f frau

		  
*--------------------------------------
*  Conditional-Effect II
*--------------------------------------
*  Plot des Marginaleffektes von "Frau" in Abängigkeit von Bildung
regress eink c.bild i.frau i.frau#c.bild         //unzentriert ist es anschaulicher

margins, at(bild=(8(1)18)) dydx(frau) noatlegend  //Konditionale MEs
 
marginsplot, recast(line) recastci(rline)                           ///
        plotopts(lwidth(thick) lcolor(blue))                        ///
		ciopts(lcolor(blue) lpattern(dash))                         ///
 		ylabel(-1200(200)200, angle(0) labsize(medlarge) grid)      /// 
		xlabel(8(1)18, labsize(medlarge) grid)                      ///
        yline(0, lcolor(red))                                       ///
		title("Konditionaler Marginaleffekt von 'Frau' und 95%-KI", ///
		      size(large) margin(medium))                           ///
        xtitle("Bildungsjahre", size(medlarge) margin(medsmall))    ///
        ytitle("Einkommensunterschied zu Männern", size(medlarge))      


* ----------------------------------
*  Vollständige Interaktion (mit Ost)
* ----------------------------------
regress eink i.ost##(i.frau c.cbild)
contrast ost ost#i.frau ost#c.cbild, overall  //Chow Test  


* --------------------------------------------------
* FINALLY: Ein korrekt spezifizierte Humankapitalmodell
*     getrennt nach Ost/West
*     mit professionellem Output nach RTF
*     und Profile-Plot für EXP
* -------------------------------------------------
generate lneink = ln(eink)
generate   exp2 = exp*exp
regress lneink bild exp exp2 frau if ost==0    //Westdeutschland
eststo
regress lneink bild exp exp2 frau if ost==1    //Ostdeutschland
eststo

* Ausgabe in einer schönen Tabelle
* Ben Jann's ESTOUT-Paket wird hier verwendet, um eine schöne RTF-Tabelle
* zu erzeugen. Installieren mit folgendem Befehl:
*    net install st0085_1.pkg
esttab using Interaktion.rtf, r2 b(%6.3f)   ///
     mtitles("West" "Ost") nonumbers        ///
     title(Das Humankaptalmodell in West- und Ostdeutschland)

* Profile-Plot für Exp (Mann, Abi)  (per Hand!! da mit "margins" schwierig in einen Plot)
estimates restore est1
gen weink = exp(_b[_cons] + _b[bild]*13 + _b[exp]*exp + _b[exp2]*exp2)  //West
estimates restore est2
gen oeink = exp(_b[_cons] + _b[bild]*13 + _b[exp]*exp + _b[exp2]*exp2)  //Ost

twoway (line weink exp if exp <= 40, lcolor(blue) lwidth(thick) sort)  ///
       (line oeink exp if exp <= 40, lcolor(red)  lwidth(thick) sort), ///
   ytitle(Einkommen, size(large))                                      ///  
   ylabel(0(500)2500, labsize(medlarge) angle(horizontal) grid)        ///
   xtitle(Berufserfahrung, size(large) margin(medsmall))               ///  
   xlabel(0(5)40, labsize(medlarge))                                   /// 
   legend(order(1 "West (Max: 35)" 2 "Ost (Max: 31)") rows(2)          ///
          size(medlarge) position(11) ring(0))

		  
*************************
* Übung für Stata-Nerds:
* Man könnte das auch mit "margins" machen. 
* Müsste ost==0 / 1 abspeichern und in ein Plot laden.
*************************
